//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "ToolConfigForm1.h"
#include "inifiles.hpp"
#include "ToolConfigAddDebuggerForm1.h"
#include "Unit1.h"
#include "ToolConfigAddDisassemberForm1.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TToolConfigForm *ToolConfigForm;
//---------------------------------------------------------------------------
__fastcall TToolConfigForm::TToolConfigForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::Calculator_BrowseClick(TObject *Sender)
{
TOpenDialog* OpenDialog = new TOpenDialog(this);

OpenDialog->DefaultExt = "exe";
OpenDialog->Filter = "Executable Files (*.exe, *.com, *.pif, *.bat)|*.exe;*.com;*.pif;*.bat";

if(OpenDialog->Execute())
    Calculator_Loc->Text = OpenDialog->FileName;

delete OpenDialog;
}
//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::HexEditor_BrowseClick(TObject *Sender)
{
TOpenDialog* OpenDialog = new TOpenDialog(this);

OpenDialog->DefaultExt = "exe";
OpenDialog->Filter = "Executable Files (*.exe, *.com, *.pif, *.bat)|*.exe;*.com;*.pif;*.bat";

if(OpenDialog->Execute())
    HexEditor_Loc->Text = OpenDialog->FileName;

delete OpenDialog;
}
//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::TextEditor_BrowseClick(TObject *Sender)
{
TOpenDialog* OpenDialog = new TOpenDialog(this);

OpenDialog->DefaultExt = "exe";
OpenDialog->Filter = "Executable Files (*.exe, *.com, *.pif, *.bat)|*.exe;*.com;*.pif;*.bat";

if(OpenDialog->Execute()) 
    TextEditor_Loc->Text = OpenDialog->FileName;	
delete OpenDialog;
}
//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::Cancel_ButtonClick(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::OK_ButtonClick(TObject *Sender)
{
TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
try
{
  IniFile->WriteString("External Tools", "Calculator", Calculator_Loc->Text);
  IniFile->WriteString("External Tools", "HexEditor", HexEditor_Loc->Text);
  IniFile->WriteString("External Tools", "TextEditor", TextEditor_Loc->Text);

  //the following are not meant to be set by the user, however they can be
  //overridden by changing the INI file before starting the app
  if (Form1->DirInfo.BasePath == "") Form1->DirInfo.BasePath = ExtractFilePath(Application->ExeName);
  IniFile->WriteString( "Integrated Tools", "Res", Form1->DirInfo.BasePath + "\Tools\\Resedit\\Resedit.exe");
  IniFile->WriteString( "Integrated Tools", "Browser", Form1->DirInfo.BasePath + "\Tools\\Browser\\Vapb.exe");
  IniFile->WriteString( "Integrated Tools", "Dump", Form1->DirInfo.BasePath + "\Tools\\Dump\\Dumpbin.exe");
  IniFile->WriteString( "Integrated Tools", "Debug", Form1->DirInfo.BasePath + "\Tools\\Debug\\nwdebug.exe");
  IniFile->WriteString( "Integrated Tools", "Dis", Form1->DirInfo.BasePath + "\Tools\\Dis\\Dis.com");

  Form1->Tools.Calc =  Calculator_Loc->Text;
  Form1->Tools.Text =  TextEditor_Loc->Text;
  Form1->Tools.Res =   Form1->DirInfo.BasePath + "\Tools\\Resedit\\Resedit.exe";
  Form1->Tools.Dump =  Form1->DirInfo.BasePath + "\Tools\\Dump\\Dumpbin.exe";
  Form1->Tools.Debug  =  Form1->DirInfo.BasePath + "\Tools\\Debug\\nwdebug.exe";
  Form1->Tools.Dis =  Form1->DirInfo.BasePath + "\Tools\\Dis\\Dis.com";
  Form1->Tools.Hex =  HexEditor_Loc->Text;
  Form1->Tools.Browse = Form1->DirInfo.BasePath + "\Tools\\Browser\\Vapb.exe";

}
catch( ... )
{
  IniFile->Free();
  throw;
}
IniFile->Free();
Form1->CreateToolsMenu();

Close();
}

//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::AddDebuggerClick(TObject *Sender)
{
TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
TStringList* Buf = new TStringList;
try
{
  IniFile->ReadSection("ExternalToolsDebuggers", Buf);
  if(Buf->Count >= 5)
	Application->MessageBox("Sorry, only five debuggers may be configured", "Error", MB_ICONERROR + MB_OK);
  else
  {
    TToolConfigAddDebuggerForm* ToolConfigAddDebuggerForm = new TToolConfigAddDebuggerForm(this);
    try
    {
      ToolConfigAddDebuggerForm->ShowModal();
    }
    catch ( ... )
    {
      delete ToolConfigAddDebuggerForm;
      throw;
    }
    delete ToolConfigAddDebuggerForm;
  }
}
catch( ... )
{
  Buf->Free();
  IniFile->Free();
  throw;
}
Buf->Free();
IniFile->Free();
}



//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::FormShow(TObject *Sender)
{

TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
try
{
  Calculator_Loc->Text = IniFile->ReadString("External Tools", "Calculator", "");
  HexEditor_Loc->Text = IniFile->ReadString("External Tools", "HexEditor", "");
  TextEditor_Loc->Text = IniFile->ReadString("External Tools", "TextEditor", "");

  DebuggerList->Clear();
  DisassemblerList->Clear();

  TStringList* Buf = new TStringList;
  try
  {
    IniFile->ReadSection("External Tools Debuggers", Buf);
    for(int i = 0;i < (Buf->Count);i++)
    {
      AnsiString FileName;
      FileName = IniFile->ReadString("External Tools Debuggers", Buf->Strings[i], "");
      if(FileName != "" && i < 5)
		DebuggerList->Items->Add(Buf->Strings[i] + ", " + FileName);
    }
    IniFile->ReadSection("External Tools Disassemblers", Buf);
    for(int i = 0;i < (Buf->Count);i++)
    {
	  AnsiString FileName;
	  FileName = IniFile->ReadString("External Tools Disassemblers", Buf->Strings[i], "");
      if(FileName != "" && i < 5)
		DisassemblerList->Items->Add(Buf->Strings[i] + ", " + FileName);
    }
  }
  catch( ... )
  {
    delete Buf;
    throw;
  }
  delete Buf;
  }

catch( ... )
{
  delete IniFile;
  throw;
}
delete IniFile;

}
//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::RemoveDebuggerClick(TObject *Sender)
{
if(DebuggerList->ItemIndex != -1)
{
  int test = Application->MessageBox("Are you sure you want to remove this debugger?", "Confirmation", MB_YESNO + MB_ICONQUESTION);
  if(test == IDYES)
  {
    TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
    TStringList* Buf = new TStringList;
    try
    {
      IniFile->ReadSection("External Tools Debuggers", Buf);
      IniFile->DeleteKey("External Tools Debuggers", Buf->Strings[DebuggerList->ItemIndex]);
      DebuggerList->Items->Delete(DebuggerList->ItemIndex);
      IniFile->ReadSection("External Tools Debuggers", Buf);


      for(int i = 0;i < 5;i++)
      {
        Form1->Tools_Debug_->Items[i]->Enabled = false;
        Form1->Tools_Debug_->Items[i]->Visible = false;
      }
      for(int i = 0;i < (Buf->Count);i++)
      {
        AnsiString FileName;
        FileName = IniFile->ReadString("External Tools Debuggers", Buf->Strings[i], "");
        if(FileName != "" && i < 5)
        {
          Form1->Tools_Debug_->Items[i]->Caption = Buf->Strings[i];
          Form1->Tools_Debug_->Items[i]->Enabled = true;
          Form1->Tools_Debug_->Items[i]->Visible = true;
        }
      }
    }
    catch( ... )
    {
      IniFile->Free();
      Buf->Free();
      throw;
    }
    IniFile->Free();
    Buf->Free();
  }
}
}

//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::AddDisassemblerClick(TObject *Sender)
{
TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
TStringList* Buf = new TStringList;
try
{
  IniFile->ReadSection("External Tools Disassemblers", Buf);
  if(Buf->Count >= 5)
	Application->MessageBox("Sorry, only five Disassemblers may be configured", "Error", MB_ICONERROR + MB_OK);
  else
  {
    TToolConfigAddDisassemblerForm* ToolConfigAddDisassemblerForm = new TToolConfigAddDisassemblerForm(this);
    try
    {
      ToolConfigAddDisassemblerForm->ShowModal();
    }
    catch ( ... )
    {
      delete ToolConfigAddDisassemblerForm;
      throw;
    }
    delete ToolConfigAddDisassemblerForm;
  }
}
catch( ... )
{
  IniFile->Free();
  Buf->Free();
  throw;
}
IniFile->Free();
Buf->Free();
}

//---------------------------------------------------------------------------
void __fastcall TToolConfigForm::RemoveDisassemblerClick(TObject *Sender)
{
if(DisassemblerList->ItemIndex != -1)
{
  int test = Application->MessageBox("Are you sure you want to remove this Disassembler?", "Confirmation", MB_YESNO + MB_ICONQUESTION);
  if(test == IDYES)
  {
    TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
    TStringList* Buf = new TStringList;
    try
    {
      IniFile->ReadSection("External Tools Disassemblers", Buf);
      IniFile->DeleteKey("External Tools Disassemblers", Buf->Strings[DisassemblerList->ItemIndex]);
      DisassemblerList->Items->Delete(DisassemblerList->ItemIndex);
      IniFile->ReadSection("External Tools Disassemblers", Buf);
      for(int i = 0;i < 5;i++)
      {
        Form1->Tools_Disassemble_->Items[i]->Enabled = false;
        Form1->Tools_Disassemble_->Items[i]->Visible = false;
      }
      for(int i = 0;i < (Buf->Count);i++)
      {
        AnsiString FileName;
        FileName = IniFile->ReadString("External Tools Disassemblers", Buf->Strings[i], "");
        if(FileName != "" && i < 5)
        {
          Form1->Tools_Disassemble_->Items[i]->Caption = Buf->Strings[i];
          Form1->Tools_Disassemble_->Items[i]->Enabled = true;
          Form1->Tools_Disassemble_->Items[i]->Visible = true;
        }
      }
    }
    catch( ... )
    {
      IniFile->Free();
      Buf->Free();
      throw;
    }
    IniFile->Free();
    Buf->Free();
  }
}
}






